// $Id: CLatchingButton.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CLatchingButton.hpp"
using Exponent::GUI::Controls::CLatchingButton;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CLatchingButton, CControl);

//	===========================================================================
CLatchingButton::CLatchingButton(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
			   : CControl(root, uniqueId, area, listener)
			   , m_downImage(NULL)
			   , m_state(false)
			   , m_cursorChange(false)
{
	EXPONENT_CLASS_CONSTRUCTION(CLatchingButton);

	this->setValue(0.0);
#ifdef WIN32
	const bool use = true;
#else
	const bool use = false;
#endif
	this->useCursorChange(use);
	NULL_POINTER(m_downImage);
}

//	===========================================================================
CLatchingButton::~CLatchingButton()
{
	EXPONENT_CLASS_DESTRUCTION(CLatchingButton);
	FORGET_COUNTED_OBJECT(m_downImage);
}

//	===========================================================================
void CLatchingButton::setValue(const double value)
{
	CControl::setValue(value);
	if (m_value >= 0.5)
	{
		m_state = true;
	}
	else
	{
		m_state = false;
	}
}

//	===========================================================================
void CLatchingButton::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	if (m_state)
	{
		if (m_downImage)
		{
			graphics.drawImage(m_downImage, m_normalisedArea, m_downImage->getNormalisedImageSize());
		}
		else
		{
			graphics.getMutableBrush()->setColour(CAlphaColour::CALPHACOLOUR_GREEN);
			graphics.fillRectangle(m_normalisedArea);

			graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_BLACK);
			graphics.drawRectangle(m_normalisedArea);

			graphics.setTextColour(CAlphaColour::CALPHACOLOUR_BLACK);
			graphics.drawText(m_labelText, m_normalisedArea, CFont::CFONT_SYSTEM_FONT, CGraphics::e_defaultSingleLine);
		}
	}
	else
	{
		if (!this->drawPrimaryImage(graphics))
		{
			graphics.getMutableBrush()->setColour(CAlphaColour::CALPHACOLOUR_RED);
			graphics.fillRectangle(m_normalisedArea);

			graphics.getMutablePen()->setColour(CAlphaColour::CALPHACOLOUR_BLACK);
			graphics.drawRectangle(m_normalisedArea);

			graphics.setTextColour(CAlphaColour::CALPHACOLOUR_BLACK);
			graphics.drawText(m_labelText, m_normalisedArea, CFont::CFONT_SYSTEM_FONT, CGraphics::e_defaultSingleLine);
		}
	}
}

//	===========================================================================
void CLatchingButton::handleLeftButtonDown(CMouseEvent &event)
{
	// Handle a click event
	if (m_cursorChange)
	{
		event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
		m_rootControl->lockControl(this);
	}
}

//	===========================================================================
void CLatchingButton::handleLeftButtonUp(CMouseEvent &event)
{
	if (m_cursorChange)
	{
		if (m_normalisedArea.pointIsInside(event.getMousePosition()))
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
		}
		else
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_ARROW);
		}
		m_rootControl->unlockControl();
	}
	this->setValue(1.0 - m_value);
	this->update();
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}

//	===========================================================================
void CLatchingButton::handleMouseMovement(CMouseEvent &event)
{
	if (m_cursorChange)
	{
		if (m_normalisedArea.pointIsInside(event.getMousePosition()))
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
			m_rootControl->lockControl(this);
		}
		else
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_ARROW);
			m_rootControl->unlockControl();
		}
	}
}

//	===========================================================================
void CLatchingButton::setDownImage(IImage *theImage)
{
	EXCHANGE_COUNTED_OBJECTS(m_downImage, theImage);
}